<?php

////
// Class to handle currencies
// TABLES: currencies
  class currencies
  {
    public $currencies;

// class constructor
    public function currencies()
    {
      $this->currencies = array();
      $currenciesTable= new Table("cc_currencies"," * ");
      $DBHandle = DBConnect();
      $return = $currenciesTable -> Get_list($DBHandle,"",0);
      $this->currencies = array();
      foreach ($return as $value) {
        $this->currencies[$value['currency']] = array('currency' => $value['currency'],
                                                       'name' => $value['name'],
                                                       'value' => $value['value'],
                                                       'decimal_point' => $value['decimal_point'],
                                                       'basecurrency' => $value['basecurrency'],
                                                       'decimal_places' => 2);
      }
    }

// class methods
    public function format($number, $calculate_currency_value = true, $currency_type = '', $currency_value = '')
    {
      global $currency;

      if (empty($currency_type)) $currency_type = $currency;

      if ($calculate_currency_value == true) {
        $rate = (tep_not_null($currency_value)) ? $currency_value : $this->currencies[$currency_type]['value'];
        $format_string = $this->currencies[$currency_type]['symbol_left'] . number_format(tep_round($number * $rate, $this->currencies[$currency_type]['decimal_places']), $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], $this->currencies[$currency_type]['thousands_point']) . $this->currencies[$currency_type]['symbol_right'];
// if the selected currency is in the european euro-conversion and the default currency is euro,
// the currency will displayed in the national currency and euro currency
        if ( (DEFAULT_CURRENCY == 'EUR') && ($currency_type == 'DEM' || $currency_type == 'BEF' || $currency_type == 'LUF' || $currency_type == 'ESP' || $currency_type == 'FRF' || $currency_type == 'IEP' || $currency_type == 'ITL' || $currency_type == 'NLG' || $currency_type == 'ATS' || $currency_type == 'PTE' || $currency_type == 'FIM' || $currency_type == 'GRD') ) {
          $format_string .= ' <small>[' . $this->format($number, true, 'EUR') . ']</small>';
        }
      } else {
        $format_string = $this->currencies[$currency_type]['symbol_left'] . number_format(tep_round($number, $this->currencies[$currency_type]['decimal_places']), $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], $this->currencies[$currency_type]['thousands_point']) . $this->currencies[$currency_type]['symbol_right'];
      }

      return $format_string;
    }

    public function is_set($code)
    {
      if (isset($this->currencies[$code]) && tep_not_null($this->currencies[$code])) {
        return true;
      } else {
        return false;
      }
    }

    public function get_value($code)
    {
      return $this->currencies[$code]['value'];
    }

    public function get_decimal_places($code)
    {
      return $this->currencies[$code]['decimal_places'];
    }

    public function display_price($products_price, $products_tax, $quantity = 1)
    {
      return $this->format(tep_add_tax($products_price, $products_tax) * $quantity);
    }
  }
