<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * This file is part of A2Billing (http://www.a2billing.net/)
 *
 * A2Billing, Commercial Open Source Telecom Billing platform,
 * powered by Star2billing S.L. <http://www.star2billing.com/>
 *
 * @copyright   Copyright (C) 2004-2015 - Star2billing S.L.
 * @author      Belaid Arezqui <areski@gmail.com>
 * @license     http://www.fsf.org/licensing/licenses/agpl-3.0.html
 * @package     A2Billing
 *
 * Software License Agreement (GNU Affero General Public License)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
**/

include '../lib/admin.defines.php';
include '../lib/admin.module.access.php';
include '../lib/admin.smarty.php';

if (! has_rights (ACX_PACKAGEOFFER)) {
    Header ("HTTP/1.0 401 Unauthorized");
    Header ("Location: PP_error.php?c=accessdenied");
    die();
}

getpost_ifset(array('customer', 'enter_cardid', 'enter_packageid', 'posted', 'Period', 'frommonth', 'fromstatsmonth', 'tomonth', 'tostatsmonth', 'fromday', 'fromstatsday_sday', 'fromstatsmonth_sday', 'today', 'tostatsday_sday', 'tostatsmonth_sday', 'stitle', 'atmenu', 'current_page', 'order', 'sens'));

if (!isset ($current_page) || ($current_page == "")) {
    $current_page=0;
}

// this variable specifie the debug type (0 => nothing, 1 => sql result, 2 => boucle checking, 3 other value checking)
$FG_DEBUG = 0;

// The variable FG_TABLE_NAME define the table name to use
$FG_TABLE_NAME="cc_card_package_offer t1 ";

if ($_SESSION["is_admin"]==0) {
     $FG_TABLE_NAME.=", cc_card t2";
}

// THIS VARIABLE DEFINE THE COLOR OF THE HEAD TABLE
$FG_TABLE_HEAD_COLOR = "#D1D9E7";

$FG_TABLE_EXTERN_COLOR = "#7F99CC"; //#CC0033 (Rouge)
$FG_TABLE_INTERN_COLOR = "#EDF3FF"; //#FFEAFF (Rose)

// THIS VARIABLE DEFINE THE COLOR OF THE HEAD TABLE
$FG_TABLE_ALTERNATE_ROW_COLOR[] = "#FFFFFF";
$FG_TABLE_ALTERNATE_ROW_COLOR[] = "#F2F8FF";

$yesno = array(); 	$yesno["1"]  = array( "Yes", "1");	 $yesno["0"]  = array( "No", "0");

$DBHandle  = DbConnect();

$FG_TABLE_COL = array();

$FG_TABLE_COL[]=array (gettext("CARDID"), "id_cc_card", "15%", "center", "SORT", "30");
$FG_TABLE_COL[]=array (gettext("CARDNUMBER"), "id_cc_card", "20%", "center", "sort", "15", "lie", "cc_card", "username", "id='%id'", "%1");
$FG_TABLE_COL[]=array (gettext("PACKAGE"), "id_cc_package_offer", "20%", "center", "sort", "15", "lie", "cc_package_offer", "label", "id='%id'", "%1");
$FG_TABLE_COL[]=array (gettext("USED MINUTES"), "used_secondes", "20%", "center", "SORT", "30", "", "", "", "", "", "display_minute");
$FG_TABLE_COL[]=array (gettext("NB PERFORMED"), "nbperf", "15%", "center", "SORT", "30");

$FG_TABLE_DEFAULT_ORDER = "t1.date_consumption";
$FG_TABLE_DEFAULT_SENS = "DESC";

$FG_COL_QUERY=' t1.id_cc_card, t1.id_cc_card, t1.id_cc_package_offer, sum(t1.used_secondes) AS used_secondes, count(*) as nbperf ';

$FG_LIMITE_DISPLAY=25;
$FG_NB_TABLE_COL=count($FG_TABLE_COL);
$FG_EDITION=true;
$FG_TOTAL_TABLE_COL = $FG_NB_TABLE_COL;
if ($FG_DELETION || $FG_EDITION) $FG_TOTAL_TABLE_COL++;

$FG_HTML_TABLE_TITLE = gettext(" - Package Info - ");
$FG_HTML_TABLE_WIDTH="85%";

if ($FG_DEBUG == 3) echo "<br>Table : $FG_TABLE_NAME  	- 	Col_query : $FG_COL_QUERY";
$instance_table = new Table($FG_TABLE_NAME, $FG_COL_QUERY);
$instance_table_graph = new Table($FG_TABLE_NAME, $FG_COL_QUERY_GRAPH);

if ( is_null ($order) || is_null($sens) ) {
    $order = $FG_TABLE_DEFAULT_ORDER;
    $sens  = $FG_TABLE_DEFAULT_SENS;
}

if ($posted==1) {
  $SQLcmd = '';
}

$date_clause='';
// Period (Month-Day)
normalize_day_of_month($fromstatsday_sday, $fromstatsmonth_sday, 1);
normalize_day_of_month($tostatsday_sday, $tostatsmonth_sday, 1);
$lastdayofmonth = date("t", strtotime($tostatsmonth.'-01'));
if ($Period=="Month") {
    if ($frommonth && isset($fromstatsmonth)) $date_clause.=" AND UNIX_TIMESTAMP(t1.date_consumption) >= UNIX_TIMESTAMP('$fromstatsmonth-01')";
    if ($tomonth && isset($tostatsmonth)) $date_clause.=" AND UNIX_TIMESTAMP(t1.date_consumption) <= UNIX_TIMESTAMP('".$tostatsmonth."-$lastdayofmonth 23:59:59')";
} else {
    if ($fromday && isset($fromstatsday_sday) && isset($fromstatsmonth_sday)) $date_clause.=" AND UNIX_TIMESTAMP(t1.date_consumption) >= UNIX_TIMESTAMP('$fromstatsmonth_sday-$fromstatsday_sday')";
    if ($today && isset($tostatsday_sday) && isset($tostatsmonth_sday)) $date_clause.=" AND UNIX_TIMESTAMP(t1.date_consumption) <= UNIX_TIMESTAMP('$tostatsmonth_sday-".sprintf("%02d",intval($tostatsday_sday)/*+1*/)." 23:59:59')";
}

if (strpos($SQLcmd, 'WHERE') > 0) {
    $FG_TABLE_CLAUSE = substr($SQLcmd,6).$date_clause;
} elseif (strpos($date_clause, 'AND') > 0) {
    $FG_TABLE_CLAUSE = substr($date_clause,5);
}

if (!isset ($FG_TABLE_CLAUSE) || strlen($FG_TABLE_CLAUSE)==0) {
    $cc_yearmonth = sprintf("%04d-%02d-%02d",date("Y"),date("n"),date("d"));
    $FG_TABLE_CLAUSE=" UNIX_TIMESTAMP(t1.date_consumption) >= UNIX_TIMESTAMP('$cc_yearmonth')";
}

if (isset($customer)  &&  ($customer>0)) {
    if (strlen($FG_TABLE_CLAUSE)>0) $FG_TABLE_CLAUSE.=" AND ";
    $FG_TABLE_CLAUSE.="t1.id_cc_card='$customer'";
} else {
    if (isset($enter_cardid)  &&  ($enter_cardid>0)) {
        if (strlen($FG_TABLE_CLAUSE)>0) $FG_TABLE_CLAUSE.=" AND ";
        $FG_TABLE_CLAUSE.="t1.id_cc_card='$enter_cardid'";
    }
}

if (isset($enter_packageid)  &&  ($enter_packageid>0)) {
    if (strlen($FG_TABLE_CLAUSE)>0) $FG_TABLE_CLAUSE.=" AND ";
    $FG_TABLE_CLAUSE.="t1.id_cc_package_offer='$enter_packageid'";
}

$FG_TABLE_CLAUSE_GROUP = $FG_TABLE_CLAUSE." GROUP BY t1.id_cc_card, t1.id_cc_package_offer ";

if (!$nodisplay) {
    $list = $instance_table -> Get_list ($DBHandle, $FG_TABLE_CLAUSE_GROUP, null, null, null, null, $FG_LIMITE_DISPLAY, $current_page*$FG_LIMITE_DISPLAY);
}
$_SESSION["pr_sql_export"]="SELECT $FG_COL_QUERY FROM $FG_TABLE_NAME WHERE $FG_TABLE_CLAUSE_GROUP";

$QUERY = "SELECT DATE(t1.date_consumption) AS day, sum(t1.used_secondes) AS used_secondes, count(*) as nbperf FROM $FG_TABLE_NAME WHERE $FG_TABLE_CLAUSE GROUP BY day ORDER BY day"; //extract(DAY from calldate)

if (!$nodisplay) {
    $res = Connection::CleanExecute($QUERY);
    if ($res) {
        $num = $res -> RecordCount();
        for ($i=0;$i<$num;$i++) {
            $list_total_day [] =$res -> fetchRow();
        }
    }

    if ($FG_DEBUG == 3) echo "<br>Clause : $FG_TABLE_CLAUSE";
    $nb_record = $instance_table -> Table_count ($DBHandle, $FG_TABLE_CLAUSE);
    if ($FG_DEBUG >= 1) var_dump ($list);

}//end IF nodisplay

if ($nb_record<=$FG_LIMITE_DISPLAY) {
    $nb_record_max=1;
} else {
    if ($nb_record % $FG_LIMITE_DISPLAY == 0) {
        $nb_record_max=(intval($nb_record/$FG_LIMITE_DISPLAY));
    } else {
        $nb_record_max=(intval($nb_record/$FG_LIMITE_DISPLAY)+1);
    }
}

$instance_table_tariff = new Table("cc_package_offer", "id, label");
$FG_TABLE_CLAUSE = "";
$list_package = $instance_table_tariff -> Get_list ($DBHandle, $FG_TABLE_CLAUSE, "label", "ASC", null, null, null, null);
$nb_package = count($list_package);

$smarty->display('main.tpl');

?>

<!-- ** ** ** ** ** Part for the research ** ** ** ** ** -->
    <center>
    <FORM METHOD="POST" name="myForm" ACTION="<?php echo $PHP_SELF?>?s=1&t=0&order=<?php echo $order?>&sens=<?php echo $sens?>&current_page=<?php echo $current_page?>">
    <INPUT TYPE="hidden" NAME="posted" value=1>
    <INPUT TYPE="hidden" NAME="current_page" value=0>
        <table class="bar-status" width="85%" border="0" cellspacing="1" cellpadding="2" align="center">
            <tbody>
            <?php  if ($_SESSION["pr_groupID"]==2 && is_numeric($_SESSION["pr_IDCust"])) { ?>
            <?php  } else { ?>
            <tr>
                <td align="left" valign="top" class="bgcolor_004">
                    <font class="fontstyle_003">&nbsp;&nbsp;<?php echo gettext("CUSTOMERS");?></font>
                </td>
                <td class="bgcolor_005" align="left">
                <table width="100%" border="0" cellspacing="0" cellpadding="0" class="bgcolor_005"><tr>
                    <td>
                        <?php echo gettext("Enter the card ID");?>: <INPUT TYPE="text" NAME="enter_cardid" value="<?php echo $enter_cardid?>" class="form_input_text">
                        <a href="#" onclick="window.open('A2B_entity_card.php?popup_select=1&popup_formname=myForm&popup_fieldname=enter_cardid' , 'CardNumberSelection','width=550,height=330,top=20,left=100,scrollbars=1');"><img src="<?php echo Images_Path;?>/icon_arrow_orange.gif"></a>
                    </td>
                </tr></table></td>
            </tr>
            <?php  }?>
            <tr>
                <td align="left" valign="top" class="bgcolor_004">
                    <font class="fontstyle_003">&nbsp;&nbsp;<?php echo gettext("PACKAGE");?></font>
                </td>
                <td class="bgcolor_005" align="left">
                <table width="100%" border="0" cellspacing="0" cellpadding="0" class="bgcolor_005"><tr>
                    <td>
                        <select NAME="enter_packageid" size="1" class="form_input_select">
                            <option class="input" value="">Select a package </option>
                            <?php
                             foreach ($list_package as $recordset) {
                            ?>
                                <option class="input" value='<?php echo $recordset[0]?>'  <?php if ($enter_packageid==$recordset[0]) echo 'selected="selected"'?>><?php echo $recordset[1]?></option>
                            <?php } ?>
                        </select>

                    </td>
                </tr></table></td>
            </tr>
            <tr>
                <td class="bgcolor_002" align="left">

                    <input type="radio" name="Period" value="Month" <?php  if (($Period=="Month") || !isset($Period)) { ?>checked="checked" <?php  } ?>>
                    <font class="fontstyle_003"><?php echo gettext("Selection of the month");?></font>
                </td>
                  <td class="bgcolor_003" align="left">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="bgcolor_003"><tr><td>
                      <input type="checkbox" name="frommonth" value="true" <?php  if ($frommonth) { ?>checked<?php }?>>
                    <?php echo gettext("From");?> : <select name="fromstatsmonth" class="form_input_select">
                    <?php
                        $monthname = array( gettext("January"), gettext("February"),gettext("March"), gettext("April"), gettext("May"), gettext("June"), gettext("July"), gettext("August"), gettext("September"), gettext("October"), gettext("November"), gettext("December"));
                        $year_actual = date("Y");
                        for ($i=$year_actual;$i >= $year_actual-1;$i--) {
                           if ($year_actual==$i) {
                            $monthnumber = date("n")-1; // Month number without lead 0.
                           } else {
                            $monthnumber=11;
                           }
                           for ($j=$monthnumber;$j>=0;$j--) {
                            $month_formated = sprintf("%02d",$j+1);
                               if ($fromstatsmonth=="$i-$month_formated")	$selected="selected";
                            else $selected="";
                            echo "<OPTION value=\"$i-$month_formated\" $selected> $monthname[$j]-$i </option>";
                           }
                        }
                    ?>
                    </select>
                    </td><td>&nbsp;&nbsp;
                    <input type="checkbox" name="tomonth" value="true" <?php  if ($tomonth) { ?>checked<?php }?>>
                    To : <select name="tostatsmonth" class="form_input_select">
                    <?php 	$year_actual = date("Y");
                        for ($i=$year_actual;$i >= $year_actual-1;$i--) {
                           if ($year_actual==$i) {
                            $monthnumber = date("n")-1; // Month number without lead 0.
                           } else {
                            $monthnumber=11;
                           }
                           for ($j=$monthnumber;$j>=0;$j--) {
                            $month_formated = sprintf("%02d",$j+1);
                               if ($tostatsmonth=="$i-$month_formated") $selected="selected";
                            else $selected="";
                            echo "<OPTION value=\"$i-$month_formated\" $selected> $monthname[$j]-$i </option>";
                           }
                        }
                    ?>
                    </select>
                    </td></tr></table>
                  </td>
            </tr>

            <tr>
                <td align="left" class="bgcolor_004">
                    <input type="radio" name="Period" value="Day" <?php  if ($Period=="Day") { ?>checked="checked" <?php  } ?>>
                    <font class="fontstyle_003"><?php echo gettext("Selection of the day");?></font>
                </td>
                  <td align="left" class="bgcolor_005">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="bgcolor_005"><tr><td>
                      <input type="checkbox" name="fromday" value="true" <?php  if ($fromday) { ?>checked<?php }?>> <?php echo gettext("From");?> :
                    <select name="fromstatsday_sday" class="form_input_select">
                        <?php
                        for ($i=1;$i<=31;$i++) {
                            if ($fromstatsday_sday==sprintf("%02d",$i)) $selected="selected";
                            else	$selected="";
                            echo '<option value="'.sprintf("%02d",$i)."\"$selected>".sprintf("%02d",$i).'</option>';
                        }
                        ?>
                    </select>
                     <select name="fromstatsmonth_sday" class="form_input_select">
                    <?php 	$year_actual = date("Y");
                        for ($i=$year_actual;$i >= $year_actual-1;$i--) {
                            if ($year_actual==$i) {
                                $monthnumber = date("n")-1; // Month number without lead 0.
                            } else {
                                $monthnumber=11;
                            }
                            for ($j=$monthnumber;$j>=0;$j--) {
                                $month_formated = sprintf("%02d",$j+1);
                                if ($fromstatsmonth_sday=="$i-$month_formated") $selected="selected";
                                else $selected="";
                                echo "<OPTION value=\"$i-$month_formated\" $selected> $monthname[$j]-$i </option>";
                            }
                        }
                    ?>
                    </select>
                    </td><td>&nbsp;&nbsp;
                    <input type="checkbox" name="today" value="true" <?php  if ($today) { ?>checked<?php }?>> <?php echo gettext("To");?>  :
                    <select name="tostatsday_sday" class="form_input_select">
                    <?php
                        for ($i=1;$i<=31;$i++) {
                            if ($tostatsday_sday==sprintf("%02d",$i)) {$selected="selected";} else {$selected="";}
                            echo '<option value="'.sprintf("%02d",$i)."\"$selected>".sprintf("%02d",$i).'</option>';
                        }
                    ?>
                    </select>
                     <select name="tostatsmonth_sday">
                    <?php 	$year_actual = date("Y");
                        for ($i=$year_actual;$i >= $year_actual-1;$i--) {
                            if ($year_actual==$i) {
                                $monthnumber = date("n")-1; // Month number without lead 0.
                            } else {
                                $monthnumber=11;
                            }
                            for ($j=$monthnumber;$j>=0;$j--) {
                                $month_formated = sprintf("%02d",$j+1);
                                   if ($tostatsmonth_sday=="$i-$month_formated") $selected="selected";
                                else	$selected="";
                                echo "<OPTION value=\"$i-$month_formated\" $selected> $monthname[$j]-$i </option>";
                            }
                        }
                    ?>
                    </select>
                    </td></tr></table>
                  </td>
            </tr>
            <tr>
                <td class="bgcolor_004" align="left" > </td>
                <td class="bgcolor_005" align="center" >
                    <input type="image"  name="image16" align="top" border="0" src="<?php echo Images_Path;?>/button-search.gif" />

                  </td>
            </tr>
        </tbody></table>
    </FORM>
</center>

<br><br>

<!-- ** ** ** ** ** Part to display the CDR ** ** ** ** ** -->
<center>
    <?php echo gettext("Calls with free minutes");?> : <?php  if (is_array($list) && count($list)>0) { echo $nb_record; } else {echo "0";}?>

      <table width="<?php echo $FG_HTML_TABLE_WIDTH?>" border="0" align="center" cellpadding="0" cellspacing="0">
        <TR bgcolor="#ffffff">
          <TD  class="bgcolor_021" height=16 style="PADDING-LEFT: 5px; PADDING-RIGHT: 3px">
            <TABLE border=0 cellPadding=0 cellSpacing=0 width="100%">
              <TBODY>
                <TR>
                  <TD><SPAN  class="fontstyle_003"><?php echo $FG_HTML_TABLE_TITLE?></SPAN></TD>
                  </TD>
                </TR>
              </TBODY>
            </TABLE></TD>
        </TR>
        <TR>
          <TD> <TABLE border=0 cellPadding=0 cellSpacing=0 width="100%">
                <TBODY>
                <TR  class="bgcolor_008">
                  <TD width="<?php echo $FG_ACTION_SIZE_COLUMN?>" align=center class="tableBodyRight" style="PADDING-BOTTOM: 2px; PADDING-LEFT: 2px; PADDING-RIGHT: 2px; PADDING-TOP: 2px"></TD>

                  <?php
                      if (is_array($list) && count($list)>0) {

                      for ($i=0;$i<$FG_NB_TABLE_COL;$i++) {
                    ?>

                  <TD width="<?php echo $FG_TABLE_COL[$i][2]?>" align=middle class="tableBody" style="PADDING-BOTTOM: 2px; PADDING-LEFT: 2px; PADDING-RIGHT: 2px; PADDING-TOP: 2px">
                    <center><strong>
                    <?php  if (strtoupper($FG_TABLE_COL[$i][4])=="SORT") {?>
                    <a href="<?php  echo $PHP_SELF."?customer=$customer&s=1&t=0&stitle=$stitle&atmenu=$atmenu&current_page=$current_page&order=".$FG_TABLE_COL[$i][1]."&sens="; if ($sens=="ASC") {echo"DESC";} else {echo"ASC";}
                    echo "&enter_cardid=$enter_cardid&enterprovider=$enterprovider&entertrunk=$entertrunk&posted=$posted&Period=$Period&frommonth=$frommonth&fromstatsmonth=$fromstatsmonth&tomonth=$tomonth&tostatsmonth=$tostatsmonth&fromday=$fromday&fromstatsday_sday=$fromstatsday_sday&fromstatsmonth_sday=$fromstatsmonth_sday&today=$today&tostatsday_sday=$tostatsday_sday&tostatsmonth_sday=$tostatsmonth_sday&dsttype=$dsttype&srctype=$srctype&clidtype=$clidtype&channel=$channel&resulttype=$resulttype&dst=$dst&src=$src&clid=$clid&terminatecauseid=$terminatecauseid";?>">
                    <span class="liens"><?php  } ?>
                    <?php echo $FG_TABLE_COL[$i][0]?>
                    <?php if ($order==$FG_TABLE_COL[$i][1] && $sens=="ASC") {?>
                    &nbsp;<img src="<?php echo Images_Path;?>/icon_up_12x12.GIF" width="12" height="12" border="0">
                    <?php } elseif ($order==$FG_TABLE_COL[$i][1] && $sens=="DESC") {?>
                    &nbsp;<img src="<?php echo Images_Path;?>/icon_down_12x12.GIF" width="12" height="12" border="0">
                    <?php }?>
                    <?php  if (strtoupper($FG_TABLE_COL[$i][4])=="SORT") {?>
                    </span></a>
                    <?php }?>
                    </strong></center></TD>
                   <?php } ?>
                   <?php if ($FG_DELETION || $FG_EDITION) { ?>

                   <?php } ?>
                </TR>

                <?php

                       $ligne_number=0;
                     //print_r($list);
                       foreach ($list as $recordset) {
                         $ligne_number++;
                ?>

                        <TR bgcolor="<?php echo $FG_TABLE_ALTERNATE_ROW_COLOR[$ligne_number%2]?>"  onMouseOver="bgColor='#C4FFD7'" onMouseOut="bgColor='<?php echo $FG_TABLE_ALTERNATE_ROW_COLOR[$ligne_number%2]?>'">
                        <TD vAlign=top align="<?php echo $FG_TABLE_COL[$i][3]?>" class=tableBody><?php  echo $ligne_number+$current_page*$FG_LIMITE_DISPLAY.".&nbsp;"; ?></TD>

                          <?php for ($i=0;$i<$FG_NB_TABLE_COL;$i++) { ?>

                        <?php
                            if ($FG_TABLE_COL[$i][6]=="lie") {

                                    $instance_sub_table = new Table($FG_TABLE_COL[$i][7], $FG_TABLE_COL[$i][8]);
                                    $sub_clause = str_replace("%id", $recordset[$i], $FG_TABLE_COL[$i][9]);
                                    $select_list = $instance_sub_table -> Get_list ($DBHandle, $sub_clause, null, null, null, null, null, null);

                                    $field_list_sun = preg_split('/,/',$FG_TABLE_COL[$i][8]);
                                    $record_display = $FG_TABLE_COL[$i][10];

                                    for ($l=1;$l<=count($field_list_sun);$l++) {
                                        $record_display = str_replace("%$l", $select_list[0][$l-1], $record_display);
                                    }

                            } elseif ($FG_TABLE_COL[$i][6]=="list") {
                                    $select_list = $FG_TABLE_COL[$i][7];
                                    $record_display = $select_list[$recordset[$i]][0];

                            } else {
                                    $record_display = $recordset[$i];
                            }

                            if ( is_numeric($FG_TABLE_COL[$i][5]) && (strlen($record_display) > $FG_TABLE_COL[$i][5])  ) {
                                $record_display = substr($record_display, 0, $FG_TABLE_COL[$i][5]-3)."";

                            }

                          ?>
                          <TD vAlign=top align="<?php echo $FG_TABLE_COL[$i][3]?>" class=tableBody><?php
                         if (isset ($FG_TABLE_COL[$i][11]) && strlen($FG_TABLE_COL[$i][11])>1) {
                                 call_user_func($FG_TABLE_COL[$i][11], $record_display);
                         } else {
                                 echo stripslashes($record_display);
                         }
                         ?></TD>
                          <?php  } ?>

                    </TR>
                <?php
                     }//foreach ($list as $recordset)
                     if ($ligne_number < $FG_LIMITE_DISPLAY)  $ligne_number_end=$ligne_number +2;
                     while ($ligne_number < $ligne_number_end) {
                         $ligne_number++;
                ?>
                    <TR bgcolor="<?php echo $FG_TABLE_ALTERNATE_ROW_COLOR[$ligne_number%2]?>">
                          <?php for ($i=0;$i<$FG_NB_TABLE_COL;$i++) {
                          ?>
                          <TD vAlign=top class=tableBody>&nbsp;</TD>
                          <?php  } ?>
                          <TD align="center" vAlign=top class=tableBodyRight>&nbsp;</TD>
                    </TR>

                <?php
                     } //END_WHILE

                  } else {
                          echo gettext("No data found !!!");
                  }//end_if
                 ?>

              </TBODY>
            </TABLE></td>
        </tr>
        <TR bgcolor="#ffffff">
          <TD  class="bgcolor_005" height=16 style="PADDING-LEFT: 5px; PADDING-RIGHT: 3px">
            <TABLE border=0 cellPadding=0 cellSpacing=0 width="100%">
              <TBODY>
                <TR>
                  <TD align="right"><SPAN  class="fontstyle_003" >
                    <?php if ($current_page>0) {?>
                    <img src="<?php echo Images_Path;?>/fleche-g.gif" width="5" height="10"> <a href="<?php echo $PHP_SELF?>?s=1&t=0&order=<?php echo $order?>&sens=<?php echo $sens?>&current_page=<?php  echo ($current_page-1)?><?php  if (!is_null($letter) && ($letter!="")) { echo "&letter=$letter";}
                    echo "&customer=$customer&posted=$posted&Period=$Period&frommonth=$frommonth&fromstatsmonth=$fromstatsmonth&tomonth=$tomonth&tostatsmonth=$tostatsmonth&fromday=$fromday&fromstatsday_sday=$fromstatsday_sday&fromstatsmonth_sday=$fromstatsmonth_sday&today=$today&tostatsday_sday=$tostatsday_sday&tostatsmonth_sday=$tostatsmonth_sday&dsttype=$dsttype&srctype=$srctype&clidtype=$clidtype&channel=$channel&resulttype=$resulttype&dst=$dst&src=$src&clid=$clid&terminatecauseid=$terminatecauseid&enter_cardid=$enter_cardid&enterprovider=$enterprovider&entertrunk=$entertrunk";?>">
                    <?php echo gettext("Previous");?> </a> -
                    <?php }?>
                    <?php echo ($current_page+1);?> / <?php  echo $nb_record_max;?>
                    <?php if ($current_page<$nb_record_max-1) {?>
                    - <a href="<?php echo $PHP_SELF?>?s=1&t=0&order=<?php echo $order?>&sens=<?php echo $sens?>&current_page=<?php  echo ($current_page+1)?><?php  if (!is_null($letter) && ($letter!="")) { echo "&letter=$letter";}
                    echo "&customer=$customer&posted=$posted&Period=$Period&frommonth=$frommonth&fromstatsmonth=$fromstatsmonth&tomonth=$tomonth&tostatsmonth=$tostatsmonth&fromday=$fromday&fromstatsday_sday=$fromstatsday_sday&fromstatsmonth_sday=$fromstatsmonth_sday&today=$today&tostatsday_sday=$tostatsday_sday&tostatsmonth_sday=$tostatsmonth_sday&dsttype=$dsttype&srctype=$srctype&clidtype=$clidtype&channel=$channel&resulttype=$resulttype&dst=$dst&src=$src&clid=$clid&terminatecauseid=$terminatecauseid&enter_cardid=$enter_cardid&enterprovider=$enterprovider&entertrunk=$entertrunk";?>">
                    <?php echo gettext("Next");?></a> <img src="<?php echo Images_Path;?>/fleche-d.gif" width="5" height="10">
                    </SPAN>
                    <?php }?>
                  </TD>
              </TBODY>
            </TABLE></TD>
        </TR>
      </table>

<?php  if (is_array($list) && count($list)>0 && 3==4) { ?>
<!-- ************** TOTAL SECTION ************* -->
            <br/>
            <div style="padding-right: 15px;">
            <table cellpadding="1" bgcolor="#000000" cellspacing="1" width="<?php if ($_SESSION["is_admin"]==1) { ?>450<?php } else {?>200<?php }?>" align="right">
                <tbody>
                <tr class="form_head">
                   <td width="33%" align="center" class="tableBodyRight" bgcolor="#600101" style="padding: 5px;"><strong><?php echo gettext("TOTAL COSTS");?></strong></td>
                   <?php if ($_SESSION["is_admin"]==1) { ?><td width="33%" align="center" class="tableBodyRight" bgcolor="#600101" style="padding: 5px;"><strong><?php echo gettext("TOTAL BUYCOSTS");?></strong></td><?php }?>
                   <?php if ($_SESSION["is_admin"]==1) { ?><td width="33%" align="center" class="tableBodyRight" bgcolor="#600101" style="padding: 5px;"><strong><?php echo gettext("DIFFERENCE");?></strong></td><?php }?>
                </tr>
                <tr>
                  <td valign="top" align="center" class="tableBody" bgcolor="white"><b><?php echo $total_cost[0][0]?></td>
                  <?php if ($_SESSION["is_admin"]==1) { ?><td valign="top" align="center" class="tableBody" bgcolor="#66FF66"><b><?php echo $total_cost[0][1]?></td><?php }?>
                  <?php if ($_SESSION["is_admin"]==1) { ?><td valign="top" align="center" class="tableBody" bgcolor="#FF6666"><b><?php echo $total_cost[0][0]-$total_cost[0][1]?></td><?php }?>

                </tr>
            </table>
            </div>
            <br/><br/>

<!-- ************** TOTAL SECTION ************* -->
<?php  } ?>

</center>
<!-- ** ** ** ** ** Part to display the GRAPHIC ** ** ** ** ** -->
<br><br>

<?php

if (is_array($list_total_day) && count($list_total_day)>0) {

$mmax=0;
$totalcall==0;
$totalminutes=0;
$totalsuccess=0;
$totalfail=0;
foreach ($list_total_day as $data) {
    if ($mmax < $data[1]) $mmax=$data[1];
    $totalcall+=$data[2];
    $totalminutes+=$data[1];
}

?>

<!-- TITLE GLOBAL -->
<center>
 <table border="0" cellspacing="0" cellpadding="0" width="80%"><tbody><tr><td align="left" height="30">
        <table cellspacing="0" cellpadding="1" bgcolor="#000000" width="50%"><tbody><tr><td>
            <table cellspacing="0" cellpadding="0" width="100%"><tbody>
                <tr><td  class="bgcolor_019" align="left"><font class="fontstyle_003"><?php echo gettext("TOTAL");?></font></td></tr>
            </tbody></table>
        </td></tr></tbody></table>
 </td></tr></tbody></table>

<!-- FIN TITLE GLOBAL MINUTES //-->

<table border="0" cellspacing="0" cellpadding="0"  width="95%">
<tbody><tr><td bgcolor="#000000">
    <table border="0" cellspacing="1" cellpadding="2" width="100%"><tbody>
    <tr>
        <td align="center" class="bgcolor_019"></td>
        <td  class="bgcolor_020" align="center" colspan="3"><font class="fontstyle_003"><?php echo gettext("PACKAGE CARD : SUMMARY");?></font></td>
    </tr>
    <tr class="bgcolor_019">
        <td align="right" class="bgcolor_020"><font class="fontstyle_003"><?php echo gettext("DATE");?></font></td>
        <td align="center"><font class="fontstyle_003"><?php echo gettext("DURATION");?></font></td>
        <td align="center"><font class="fontstyle_003"><?php echo gettext("GRAPHIC");?></font></td>
        <td align="center"><font class="fontstyle_003"><?php echo gettext("PERFORMED");?></font></td>

        <!-- LOOP -->
    <?php
        $i=0;
        $j=0;
        foreach ($list_total_day as $data) {
        $i=($i+1)%2;

        if ((!isset($resulttype)) || ($resulttype=="min")) {
                $minutes = sprintf("%02d",intval($data[1]/60)).":".sprintf("%02d",intval($data[1]%60));
        } else {
                $minutes = $data[1];
        }
        if ($mmax>0) 	$widthbar= intval(($data[1]/$mmax)*200);
    ?>
        </tr><tr>
        <td align="right" class="sidenav" nowrap="nowrap"><font class="fontstyle_003"><?php echo $data[0]?></font></td>
        <td bgcolor="<?php echo $FG_TABLE_ALTERNATE_ROW_COLOR[$i]?>" align="right" nowrap="nowrap"><font class="fontstyle_006"><?php echo $minutes?> </font></td>
        <td bgcolor="<?php echo $FG_TABLE_ALTERNATE_ROW_COLOR[$i]?>" align="left" nowrap="nowrap" width="<?php echo $widthbar+60?>">
        <table cellspacing="0" cellpadding="0"><tbody><tr>
        <td bgcolor="#e22424"><img src="<?php echo Images_Path;?>/spacer.gif" width="<?php echo $widthbar?>" height="6"></td>
        </tr></tbody></table></td>
        <td bgcolor="<?php echo $FG_TABLE_ALTERNATE_ROW_COLOR[$i]?>" align="right" nowrap="nowrap"><font class="fontstyle_006"><?php echo $data[2]?></font></td>
     <?php 	 $j++;}

        if ((!isset($resulttype)) || ($resulttype=="min")) {
            $total_tmc = sprintf("%02d",intval(($totalminutes/$totalcall)/60)).":".sprintf("%02d",intval(($totalminutes/$totalcall)%60));
            $totalminutes = sprintf("%02d",intval($totalminutes/60)).":".sprintf("%02d",intval($totalminutes%60));
        } else {
            $total_tmc = intval($totalminutes/$totalcall);
        }

     ?>
    </tr>
    <!-- FIN DETAIL -->

    <!-- FIN BOUCLE -->

    <!-- TOTAL -->
    <tr bgcolor="bgcolor_019">
        <td align="right" nowrap="nowrap"><font class="fontstyle_003"><?php echo gettext("TOTAL");?></font></td>
        <td align="center" nowrap="nowrap" colspan="2"><font class="fontstyle_003"><?php echo $totalminutes?> </font></td>
        <td align="center" nowrap="nowrap"><font class="fontstyle_003"><?php echo $totalcall?></font></td>
    </tr>
    <!-- FIN TOTAL -->

      </tbody></table>
      <!-- Fin Tableau Global //-->

</td></tr></tbody></table>

<?php  } else { ?>
    <center><h3><?php echo gettext("No calls in your selection");?>.</h3></center>
<?php  } ?>
</center>

<?php

$smarty->display('footer.tpl');
