<?php
App::import('Vendor','xtcpdf');
$paging = Configure::read('Pdf');

$textfont      = $paging['font'];
$footerHeight = 0;
$title = $this->data['Instance']['voucher_title'];
$logo = $this->data['Instance']['voucher_logo'];
$currency = $this->data['Instance']['currency'];

$w = 85;
$h = 45;
$x= 15;
$x_diff= $w + 10;
$y_diff= $h + 5;
$i=1;
$y=10;


$vouchers = $this->data['Voucher'];

foreach($vouchers as $voucher){

$pdf = new XTCPDF();
$pdf->SetTitle($paging['title']);
$pdf->SetSubject($paging['subject']);
$pdf->SetAuthor($paging['author']);
$pdf->SetCreator($paging['creator']);
$pdf->SetAutoPageBreak( true, $footerHeight );
$pdf->SetTopMargin(5);
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); 
$pdf->setJPEGQuality(75);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFillColor(141,216,237);

$page=0;

      $filename = $paging['path'].$this->data['Instance']['name']."_".$voucher['id'].".pdf";

	  $pdf->AddPage();      

	  $voucher_keys = unserialize($voucher['voucher_keys']);
	  $units = $voucher['units'];
	  $credit = $voucher['credit'];

	  $text1 ="<span><br/>  ".$title."</span>";
	  $text2 ="<span>Credit: ".$credit." ".$currency."</span>";
	  $date ="<span>Date of issue: ".date('j M Y, H:i A')."<br/>";
	  

	  for ($i=1;$i<=$units;$i++){


	  unset($text3);
	  $key = $voucher_keys[$i-1];
	  $text3 = $date."Voucher id: ".$key."</span>";

	      if (($i % 2) == 0){ //  TRUE if $i even.
	       	   $nl=1;
	   	   $posX = $x + $x_diff;
   	   	   }
	   	   else {
	  	   $nl=0;
	   	   $posX= $x;
	      }
	      $row = ceil($i/2);
	      $posY = $y + (($row-1)-(5*$page))*$y_diff;

	      $pdf->Image('img/logo/'.$logo, $posX, $posY, 25, 25, '', '', '', true, 150);

	      $pdf->SetFont($textfont,'B',14);
	      $pdf->MultiCell($w, $h, $text1, 1, 'C', 1, $nl, $posX, $posY, true,0,true,0);

	      $pdf->SetFont($textfont,'',12);
	      $pdf->MultiCell($w, $h, $text2, 0, 'C', 0, 0, $posX, $posY+15, true,0,true,0);

	      $pdf->SetFont($textfont,'',8);
	      $pdf->MultiCell($w, $h, $text3, 0, 'L', 0, 0, $posX, $posY+35, true,0,true,0);

	      if( $i>9 && ($i % 10) == 0){	
	      	  $pdf->AddPage();      
		  $page++;
		    }




	      } //for

	    $page=0;

	    ob_clean();
	    $pdf->Output($filename, 'F');

	    }

?> 

