<?
class Instance extends AppModel {

    var $name = 'Instance';

    var $hasMany = array('Voucher','Provider');



      var $validate = array(
        'language' => array(
            'rule'     => 'alphaNumeric',
            'message'  => 'Please select your base language.' ),
        'country' => array(
            'rule'     => 'alphaNumeric',
            'message'  => 'Please select your base country.' ),
        'currency' => array(
            'rule'     => 'alphaNumeric',
            'message'  => 'Please select your base currency.' ),
        'customer_pool' => array(
	    'rule' =>  'numeric',
            'message'  => 'Please state the amount of customers you want to create.' ),
        'did_prefix' => array(
	    'numeric' => array(
	    	      	 'rule' => 'numeric',
			 'message' => 'Only digits allowed'
			 ),
	    'range' => array(
	    	      	 'rule' => array('range',100,999),
			 'message' => 'Please enter a 3 digit code between 100 and 999.')
			 ),
	'rate_local' => array(
		     	'rule' => 'numeric',
			'message' => 'Digits only.'),
	'voucher_title' => array(
		     	'rule' => array('between', 1 , 20 ),
			'message' =>'Maximum 20 characters.'),
	'customer_balance' => array(
		     	'rule' => 'numeric',
			'message' => 'Digits only.')
			);

	function isOpen($id){

		 if($this->data['Instance']['open']){
			return true;
			}
			else {
			return false;
			}

	}


	function createInstance($id){

	$instances= $this->data['Instance'];
	$vouchers = $this->data['Voucher'];



		  $result = $this->requestAction('/soap/Create_Instance');

		  if (strpos($result[1],'SUCCESS')===false){  
		     $this->log($result[1],"instance");	
		  }
		  else {

		  $instance = $result[0];
		  $this->saveField('name',$instance);
		  $this->log($result[1],"instance");
		  
		  $result = $this->requestAction('/soap/Set_InstanceDescription/'.$instance);
		  
			if (strpos($result[1],'SUCCESS')===false){
			   //write notification error
		     	   $this->log("Instance description could not be set. Error: ".$result[0],"instance");	
		  	}
			else {
			   $this->log($result[1],"instance");	

			   $result = $this->requestAction('/soap/Set_Setting/base_currency/'.$instances['currency']);
			   	if (strpos($result[1],'SUCCESS')===false){
			   	   //write notification error
		     	   	   $this->log("Base currency could not be set. Error: ".$result[0],"instance");	
				}
				else {
				   $this->log($result[1],"instance");
				   $result = $this->requestAction('/soap/Set_Setting/base_country/'.$instances['country']);
				   	if (strpos($result[1],'SUCCESS')===false){
		     	   	   	   $this->log("Base country could not be set. Error: ".$result[0],"instance");
					   }
					else {
					     $this->log($result[1],"instance");
			   		     $result = $this->requestAction('/soap/Set_Setting/base_language/'.$instances['language']);
				   	     	 if (strpos($result[1],'SUCCESS')===false){
		     	   	   	   	    $this->log("Base langauge could not be set. Error: ".$result[0],"instance");
					   	    }
						    else {
							 $this->log($result[1],"instance");			 
						         $result = $this->requestAction('/soap/Create_DIDGroup/'.$instance);
				   	     	 	 	 if (strpos($result[1],'SUCCESS')===false){
		     	   	   	   	    		    $this->log("DID group could not be created. Error: ".$result[0],"instance");
								 }
								 else {
								      $id_didgroup = $result[0];
								      $this->log($result[1],"instance");
						         	      $result = $this->requestAction('/soap/Create_Provider/'.$instance);
				   	     	 	 	      	  if (strpos($result[1],'SUCCESS')===false){
  									     $this->log("Provider could not be created. Error: ".$result[0],"instance");
									  }
									  else {
									       $id_provider = $result[0];
									       $this->log($result[1],"instance");
									       $result = $this->requestAction('/soap/Create_Ratecard/'.$instance);
       	       				   	     	 	 	      	  if (strpos($result[1],'SUCCESS')===false){
  									     	     $this->log("Ratecard could not be created. Error: ".$result[0],"instance");
										  }
										  else {
										     $id_ratecard=$result[0];
										     $this->log($result[1],"instance");
										     $result = $this->requestAction('/soap/Create_Callplan/'.$instance."/".$id_ratecard);
										     	if (strpos($result[1],'SUCCESS')===false){
											}
											else {
											     $id_callplan=$result[0];
											     $this->log($result[1],"instance");
										   	     
												foreach($vouchers as $key => $voucher){
											     	$result = $this->requestAction('/soap/Create_Voucher/'.$voucher['credit']."/".$voucher['units']."/".$instances['currency']);
												$this->log($result[1],"instance");
												$voucher_keys[$voucher['id']] = $result[0];
												
											     	}
												$result = $this->requestAction("/soap/Create_Customer/".$instance."/".$id_callplan."/".$id_didgroup."/".$instances['customer_pool']."/".$instances['customer_balance']."/".$instances['currency']."/".$instances['language'].'/'.$instances['country']);
												
												if (strpos($result[1],'SUCCESS')===false){
  									     	     		   $this->log("Customers could not be created. Error: ".$result[0],"instance");
										  		   }
										  		   else {
										     		   $this->log($result[1],"instance");
												   
      												   $account_id = base64_encode($result[0]); //serialized to base64
												   $this->saveField('account_id',$result[0]);												 
													$result = $this->requestAction('/soap/Create_DID/'.$account_id."/".$id_didgroup."/".$instances['rate_local']."/".$instances['did_prefix']."/".$instances['country']);
												   	
												   	if (strpos($result[1],'SUCCESS')===false){
													$this->log("Local DID could not be created. Error: ".$result[0],"instance");
													}
													else {
													$this->log($result[1],"instance");
													$this->saveField('did_id',$result[0]);												    					   	            return $voucher_keys;
													}
												   }
											     
											     
											}
  										  }
									  }
								 }
						    }
					}	
				}
			   	   
			}

		  }

	}


}
?>