<?php

class InstancesController extends AppController{

      var $name = 'Instances';

      var $helpers = array('Html','Form','Javascript','Ajax','FileManagement','Session');      



      function index(){

      	       //Instance exist
      	       if ($this->Instance->find('count')){

	       	  $this->data = $this->Instance->find('first');



		  //Instance is incomplete (open)
		  if ($this->data['Instance']['open']){

		  $id = $this->data['Instance']['id'];
		  $this->redirect(array('action'=>'page1/'.$id));
		

		  }

		  //Instance is completed
		  else {
		  $this->render();
		  }

	       }


	       //No instance, create one
	       else {

	       $this->redirect(array('action'=>'auth'));

	       }


      }

      function auth(){

      	       $default = Configure::read('Settings.Default_Pwd');

      	       //Render empty form
      	       if (empty($this->data)){

	       	  $this->render();

		  }

		  else {

		  $auth = $this->data['Instance'];
		  $pwd=$auth['password'];
		  $user = $auth['username'];
		  $result = $this->requestAction('/soap/Authenticate_Admin/'.$user.'/'.$pwd);

		  //Validate credentials

		  	     //Authentication OK and admin password != default
		  	     if ($result[0]=='true' && $pwd != $default){
			     	$this->redirect(array('action'=>'page1'));
		  		}

			     //Authentication OK, but default password in use	
  	     	  	     if ($result[0]=='true' && $pwd == $default){
				$this->redirect(array('action'=>'changePwd'));
			     }
			     else {
    			         $this->Session->setFlash(__('Incorrect password. Please try again.', true));      	  
			     	  $this->render();
			     }    


		  }

      }


      function changePwd(){


      	       //Render view
      	       if(empty($this->data)){
			$this->render();
		}

		//Validate and save data
		else {

	       	$this->Instance->set( $this->data );
		$instance = $this->data['Instance'];
	
			if($instance['password1'] === $instance['password2'] ){

			
				//Update admin password
		      	 	$result = $this->requestAction('/soap/Set_AdminPwd/'.$instance['username']."/".$instance['password1']);
				

				if ($result[0]){
				   $this->redirect(array('action'=>'page1'));
				   }
				   else {
				   $this->Session->setFlash(__('Admin password could not be changed (SOAP error).', true)); 
				}


				}
			else {

				//New passwords does not match, render view with error message
				$this->Session->setFlash(__('The passwords do not match. Please try again.', true)); 
			}			
						  

		}


      }


      //Environment
      function page1($id = null){


       	       //Render form
      	       if (empty($this->data)){

			//Edit existing data
			//ADD: If id exists, check that an entry with that id exist (and the entry is open for edit), else go to index
			
		   if($id){
			$this->Instance->id = $id;
			$this->data = $this->Instance->read(null,$id);
			$this->Instance->set( $this->data );	

			if($this->Instance->isOpen($id)){
				$this->Instance->id = $id;
				$this->data = $this->Instance->read(null,$id);
				$this->set('data',$this->Instance->read());       
				}

			elseif($id && !$this->Instance->isOpen($id)){
				
				$this->redirect(array('action'=>'/'));

			}
			} //id exist

			else {
			     $this->set('data',null);       
				
			} //no id
			} //empty data			
				



	       //Validate and save form data

		else {

	       	     $this->Instance->set( $this->data );

		      //Entry exist (update)
	       	      if(array_key_exists('id',$this->data['Instance'])){

		     
			$id = $this->data['Instance']['id'];
			//ADD: CHECK THAT ENTRY WITH ID EXIST AND ENTRY IS OPEN
	       	    	

			$this->Instance->save($this->data['Instance']);
			$this->redirect(array('action'=>'page2/'.$id));

			}

		       //New entry (insert)
		       else  {

	       	    	$this->Instance->save($this->data);
	 	    	$id = $this->Instance->getLastInsertId();
           	    	$this->redirect(array('action'=>'page2/'.$id));
		  
			}
		}	 	  


	 }


      //Customers
      function page2($id = null){

		if (!$id && empty($this->data)){ 
			$this->Session->setFlash(__('Invalid id', true)); 
			$this->redirect(array('action'=>'index')); 
		} 

		//No form data, fetch data from db and display
		elseif (empty($this->data)){ 

		$this->Instance->id = $id;
		$this->data = $this->Instance->read(null,$id);
		$this->set('data',$this->Instance->read());       

			if($this->Instance->isOpen($id)){
				$this->render();
				}
				else {
				$this->redirect(array('action'=>'/'));

				}



		} 


       	       // Form data exist, save and redirect to Page2 or Page4
               elseif (!empty($this->data)){ 

	       	      //fetch form data
	       	      $this->Instance->set( $this->data );

		      $did_prefix = $this->data['Instance']['did_prefix'];

		      //validate DID prefix
		      $result=array();
		      if ($did_prefix) {
		      	 $result = $this->requestAction('/soap/Validate_DIDPrefix/'.$did_prefix);
		      }

			 //Validation success
			 if ($result[0]){

		      	    //Save instance data
	 	      	    if ($this->Instance->save($this->data['Instance'])){

           	      	       //Redirect according to action

		      	       if ($this->data['Instance']['submit'] == 'prev') {
		      	       	  $this->redirect(array('action'=>'page1/'.$id));
			       }
		      	       else {
			       	    $this->redirect(array('action'=>'page3/'.$id));
			       }
			     }
			     
			     
			}

			else {

			//Validation of DID failed.
			$this->Session->setFlash(__('The selected prefix is already in use. Please select another three digit code.', true)); 

			}
	 	}

}

	//Rates
      	function page3($id = null){

		if (!$id && empty($this->data)){ 
			$this->Session->setFlash(__('Invalid id', true)); 
			$this->redirect(array('action'=>'index')); 
		} 

		//No form data, fetch data from db and display
		elseif (empty($this->data)){ 

		$this->Instance->id = $id;
		$this->data = $this->Instance->read(null,$id);
		$this->set('data',$this->Instance->read());       

			if($this->Instance->isOpen($id)){
				$this->render();
				}
				else {
				$this->redirect(array('action'=>'/'));

				}



		} 


       	       // Form data exist, save and redirect to Page2 or Page4
               elseif (!empty($this->data)){ 


	       	      //fetch form data
	       	      $this->Instance->set( $this->data );

		      //Validate and save data
	 	      if ($this->Instance->save($this->data['Instance'])){

           	      	 //Validation OK: redirect according to action

		      	 if ($this->data['Instance']['submit'] == 'prev') {

		      	    $this->redirect(array('action'=>'page2/'.$id));
			    }
		      	    else {
			    $this->redirect(array('action'=>'page4/'.$id));
			    }
			 }

	 	  }

		  }


      //Vouchers
      function page4($id = null){


		if (!$id && empty($this->data)){ 
			$this->Session->setFlash(__('Invalid id', true)); 
			$this->redirect(array('action'=>'index')); 
		} 


		
		elseif (empty($this->data)){ 


		$this->Instance->id = $id;
		$this->data = $this->Instance->read(null,$id);
		$this->set('data',$this->Instance->read());       


			if($this->Instance->isOpen($id)){
				$this->render();
				}
				else {
				$this->redirect(array('action'=>'/'));
				}


		} 


       	       // Form data exist, save and redirect to Page1/3
               elseif (!empty($this->data)){ 

	       	      //fetch form data
	       	      $this->Instance->set( $this->data );

		      
	       	      //Set instance_id for each vote
	       	      foreach ($this->data['Voucher'] as $key => $value){
		      	      $this->data['Voucher'][$key]['instance_id']=$id; 
	 		      }


		      //Save voucher data
	 	      $this->Instance->Voucher->saveAll($this->data['Voucher']);

           	      //Redirect according to action

		      if ($this->data['Instance']['submit'] == 'prev') {

		      	 $this->redirect(array('action'=>'page3/'.$id));
			 }
		      else {
			 $this->redirect(array('action'=>'page5/'.$id));
			 }
		  
	 	  }


	 }

	 //Voucher design
	 function page5($id){

		     	if (!$id && empty($this->data)){ 
			   $this->Session->setFlash(__('Invalid option', true)); 
			   $this->redirect(array('action'=>'index')); 
			} 

			//No form data, fetch data from db and display
			elseif (empty($this->data)){ 

			       $this->Instance->id = $id;
			       $this->data = $this->Instance->read(null,$id);
			       $this->set('data',$this->Instance->read());       

			       if($this->Instance->isOpen($id)){
					$this->render();
				}
				else {
					$this->redirect(array('action'=>'/'));
				}

			}
			
			elseif(!empty($this->data)){

				//fetch form data
	       	      		$this->Instance->set( $this->data );


		      		//Validate and save data
	 	      		if ($this->Instance->save($this->data)){


           	      	 	   //Validation OK: redirect according to action
		      	 	   if ($this->data['Instance']['submit'] == 'prev') {
		      	    	      $this->redirect(array('action'=>'page4/'.$id));
			    	   }
		      	    	   else {
			    	   	$this->redirect(array('action'=>'createInstance/'.$id));
			    	   }
			 	}
				else {
				$this->render();
				}   
	 	  	}
	}


    function delete ($id,$voucher_id){

    	     if($this->Instance->Voucher->del($voucher_id))
	     {
	     $this->log('Msg: Voucher deleted ','instance');
	     $this->redirect(array('action' => 'page4/'.$id));
	     }

    }


	function createInstance($id){



		//no id, redirecto to index
		if (!$id){ 
			$this->Session->setFlash(__('Invalid id', true)); 
			$this->redirect(array('action'=>'index')); 
		} 


		 //Render view
		  if(!$this->data){


			$this->Instance->id = $id;
			$this->data = $this->Instance->read(null,$id);

			       if($this->Instance->isOpen($id)){
					$this->render();
				}
				else {
					$this->redirect(array('action'=>'/'));
				}
   	

		  }

		  //Apply logic
		  else {

		       //Create instance in A2Billing
		       if($this->data['Instance']['submit']=='Create'){


			$this->Instance->id = $id;
			$this->data = $this->Instance->read(null,$id);
			$this->Instance->set( $this->data );	


			if ($this->Instance->isOpen($id)){

			    $this->Session->setFlash(__('Creating instance', true));

			    $result = $this->Instance->createInstance($id);

			    $this->Instance->saveField('open',false); 
			   
			    $this->Session->setFlash(__('Creating vouchers', true)); 
			    
			    if (is_array($result)){
			       foreach($result as $key => $voucher_keys){
			    	  $this->Instance->Voucher->id = $key;
			   	  $this->Instance->Voucher->saveField('voucher_keys',$voucher_keys);
				  $this-> data = $this->Instance->findById($id);
				  
			   	  $this->Instance->Voucher->saveField('filename',$this->data['Instance']['name']."_".$key.".pdf");
		  	    $this->requestAction('instances/viewPdf/'.$id);

				}
			    }
			    

 			    $this->redirect(array('action'=>'index'));

			  } 

			  //Existing entry is closed
			  else {
			       $this->redirect(array('action'=>'/'));

			  }
		       }

		       //Edit existing data
		       else {
 			    $this->redirect(array('action'=>'page5/'.$id));
			    }	  


		  }

		  
	}

/*
    function provisioning($id){

	$this->Instance->id = $id;

	if($this->data = $this->Instance->read(null,$id)){

	     $this->set('data',$this->Instance->read());       
             $this->render();
	     }
	     else {

	     $this->redirect(array('action'=>'/'));
	     }
    } */


    function viewPdf($id = null){

	$this->Instance->id = $id;
	$this->data = $this->Instance->read(null,$id);
	$this->set('data',$this->Instance->read());       

        $this->render();
    } 

/*
    function listProviders(){

      	     $providers = Configure::read('Providers');
	     	     
    	     	     $result = $this->requestAction('soap/Get_ProvisioningList/'.base64_encode($providers));
		     
	             //successful transaction 	     
		     if (strpos($result[1],'SUCCESS')){  
		     $data = unserialize($result[0]);
		     		     }


	     $this->set('data',$data);       
    	     $this->render();

    }
*/


    function list_vouchers(){

    	     //Show only if a complete instance exist
    	     if ($this->Instance->find('count')){

       	     	$this->data = $this->Instance->find('first');
       		$this->Instance->set( $this->data );	

		$id = $this->data['Instance']['id'];
       		if($this->Instance->isOpen($id)) {

			$this->render();
       		}

		}
       		else {
       
			$this->redirect(array('action'=>'/'));
       		}			     

    }

      //Vouchers
      function vouchers($id = null){

      	        //Display empty form
		if (empty($this->data)){ 

			if(!$this->Instance->isOpen($id)){
				$this->render();
				}
				else {
				$this->redirect(array('action'=>'page1/'.$id));
				}


		} 


       	       // Form data exist, save and redirect to Page1/3
               elseif (!empty($this->data)){ 

	       	      //fetch form data
	       	      $this->Instance->set( $this->data );

		      
	       	      //Set instance_id for each vote
	       	      foreach ($this->data['Voucher'] as $key => $value){
		      	      $this->data['Voucher'][$key]['instance_id']=$id; 
	 		      }


		      //Save voucher data
	 	      $this->Instance->Voucher->saveAll($this->data['Voucher']);

           	      //Redirect according to action

		      if ($this->data['Instance']['submit'] == 'prev') {

		      	 $this->redirect(array('action'=>'page3/'.$id));
			 }
		      else {
			 $this->redirect(array('action'=>'page5/'.$id));
			 }
		  
	 	  }
	       }



    function customers(){


    	     if ($this->Instance->find('count')){

       	     	$this->data = $this->Instance->find('first');
       		$this->Instance->set( $this->data );	

		$id = $this->data['Instance']['id'];
       		if($this->Instance->isOpen($id)) {

			$this->render();
       		}

		} else {
       
			$this->redirect(array('action'=>'/'));
       		}			     

    }



}
?>